VERSION 5.00
Begin VB.Form Form1 
   BorderStyle     =   3  'Fester Dialog
   Caption         =   "Form1"
   ClientHeight    =   2470
   ClientLeft      =   50
   ClientTop       =   340
   ClientWidth     =   4430
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   2470
   ScaleWidth      =   4430
   StartUpPosition =   2  'Bildschirmmitte
   Begin VB.CommandButton Command1 
      Caption         =   "Create PDF"
      Height          =   855
      Left            =   720
      TabIndex        =   0
      Top             =   720
      Width           =   3015
   End
End
Attribute VB_Name = "Form1"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Function GetFullPathName Lib "kernel32" Alias "GetFullPathNameW" (ByVal lpFileName As Long, ByVal nBufferLength As Long, ByVal lpBuffer As Long, ByVal lpFilePart As Long) As Long
Private Declare Function ShellExecuteA Lib "shell32.dll" (ByVal hWnd As Long, ByVal lpOperation As String, ByVal lpFile As String, ByVal lpParameters As String, ByVal lpDirectory As String, ByVal nShowCmd As Long) As Long
Private WithEvents pdf As CPDF 'Activate event support
Attribute pdf.VB_VarHelpID = -1

Private Sub pdf_Error(ByVal Description As String, ByVal ErrType As Long, DoBreak As Boolean)
   MsgBox Description, vbExclamation, "Error"
   DoBreak = False ' We break processing if an error occurred!
End Sub

Private Sub Form_Load()
   On Error GoTo Err
   Set pdf = New CPDF
   Exit Sub
Err:
   MsgBox "Out of memory!", vbCritical, "Fatal error"
End Sub

Private Sub Form_Terminate()
   Set pdf = Nothing
End Sub

Function GetFullPath(ByVal Path As String) As String
   Dim sLen As Long
   GetFullPath = Space(512)
   sLen = GetFullPathName(StrPtr(Path), 511, StrPtr(GetFullPath), 0)
   GetFullPath = Left(GetFullPath, sLen)
End Function

Private Sub Command1_Click()
   ' Error messages and warnings are passed to the error event function.
   Call pdf.CreateNewPDF(vbNullString) ' The ouput file is opened later

   ' Set the license key here if you have one
   ' pdf.SetLicenseKey("")

   ' Non embedded CID fonts depend usually on the availability of external cmaps.
   ' So, external cmaps should be loaded if possible.
   Call pdf.SetCMapDir(GetFullPath("../../../Resource/CMap"), TLoadCMapFlags.lcmDelayed Or TLoadCMapFlags.lcmRecursive)

   Call pdf.SetImportFlags(TImportFlags.ifImportAll Or TImportFlags.ifImportAsPage)
   Call pdf.SetImportFlags2(TImportFlags2.if2UseProxy)
   Call pdf.OpenImportFile("../../../dynapdf_help.pdf", ptOpen, "")
   Call pdf.ImportPDFFile(1, 1#, 1#)

   Dim i, cnt As Integer
   Dim ctx As CPDFContentParser
   Set ctx = New CPDFContentParser
   
   Call ctx.CreateParserContext(pdf, TOptimizeFlags.ofDefault)

   Dim out As TContent
   Dim searchText, replaceText As String
   Dim curr As TTextSelection, sel As TTextSelection
   Dim currPtr As Long

   searchText = "PDF"  ' This string occurs of course very often in the help file
   replaceText = "XDF" ' Just an example. Use also a longer or shorter string to see what happens...

   cnt = pdf.GetPageCount()
   For i = 1 To cnt
      ' The flag cpfEnableTextSelection is required. Otherwise no text can be found.
      If ctx.ParsePage(i, TContentParseFlags.cpfEnableTextSelection, out) Then
         currPtr = 0
         ' Replace all occurences of "PDF" with "XDF" (case insensitive).
         While ctx.FindText(TSearchType.stCaseInSensitive, currPtr, searchText, sel)
            ' Set the replacement string to an empty string one time to see how surrounding text will be handled...
            ' With psrSetAltFont() you can also set the preferred alternate font to output the new text if the
            ' original font is not available on the system.
            Call ctx.ReplaceSelText(rtfDefault, sel, replaceText)
            curr = sel
            currPtr = VarPtr(curr)
         Wend
         Call ctx.WriteToPage(TOptimizeFlags.ofDefault)
      End If
   Next
   Set ctx = Nothing

   ' No fatal error occurred?
   If pdf.HaveOpenDoc Then
      ' OK, now we can open the output file.
      Dim OutFile As String
      OutFile = App.Path + "\out.pdf"
      If pdf.OpenOutputFile(OutFile) Then
         If pdf.CloseFile Then
            ShellExecuteA Me.hWnd, "open", OutFile, vbNullString, vbNullString, 1
         End If
      End If
   End If
End Sub
